/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.api.IRuneColorProvider;

public class RunedModifier
extends NoLevelsModifier {
    static boolean enabled = ModList.get().isLoaded("quark");
    public static final ResourceLocation RUNE = new ResourceLocation("materialis", "rune");

    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        volatileData.putBoolean(IModifiable.SHINY, true);
    }

    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(RUNE);
    }

    public Component getDisplayName(IToolStackView tool, int level) {
        if (!enabled || !tool.getPersistentData().contains(RUNE, 10)) {
            return super.getDisplayName();
        }
        int color = RunedModifier.getColor(tool);
        int colorRGB = color > 15 ? Color.HSBtoRGB(ClientTicker.total / 100.0f, 1.0f, 1.0f) : DyeColor.m_41053_((int)color).m_41070_();
        return new TranslatableComponent(this.getTranslationKey()).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)colorRGB)));
    }

    public static int getColor(IToolStackView tool) {
        ItemStack stack;
        if (enabled && FMLEnvironment.dist == Dist.CLIENT && tool.getPersistentData().contains(RUNE, 10) && (stack = ItemStack.m_41712_((CompoundTag)tool.getPersistentData().getCompound(RUNE))).m_41720_() instanceof IRuneColorProvider) {
            return ((IRuneColorProvider)stack.m_41720_()).getRuneColor(stack);
        }
        return 16;
    }
}

